package gov.va.vamf.scheduling.direct.domain

import spock.lang.Specification
import spock.lang.Unroll

class RequestEligibilityCriteriaSpec extends Specification {
    private RequestEligibilityCriteria requestEligibilityCriteria

    def setup() {
        requestEligibilityCriteria = new RequestEligibilityCriteria()
    }

    @Unroll
    def 'RequestEligibilityCriteria should return the same #property when set to a non-null value'() {
        when:
        requestEligibilityCriteria[property] = settings

        then:
        requestEligibilityCriteria[property] == settings

        where:
        property                | settings
        'requestSettings'       | makeCoreSettings(1)
        'customRequestSettings' | makeCustomRequestSettings(1)
    }

    def 'RequestEligibilityCriteria#getSetting(String) should find a setting by id'() {
        when:
        requestEligibilityCriteria[property] = settings

        then:
        requestEligibilityCriteria.getSetting(settings[0].id).orElse(null) == settings[0]
        requestEligibilityCriteria.getSetting(settings[1].id).orElse(null) == settings[1]
        requestEligibilityCriteria.getSetting(settings[2].id).orElse(null) == settings[2]

        where:
        property                | settings
        'requestSettings'       | makeCoreSettings(3)
        'customRequestSettings' | makeCustomRequestSettings(3)
    }

    def 'RequestEligibilityCriteria#getSetting(String) should return an empty Optional when a setting is not found'() {
        when:
        requestEligibilityCriteria.requestSettings = requestSettings
        requestEligibilityCriteria.customRequestSettings = customRequestSettings

        then:
        !requestEligibilityCriteria.getSetting('nope').isPresent()

        where:
        requestSettings     | customRequestSettings
        null                | null
        makeCoreSettings(0) | makeCustomRequestSettings(0)
        makeCoreSettings(3) | makeCustomRequestSettings(3)
    }

    private def makeCoreSettings(count) {
        (1..count).collect { new CoreSetting("id-$it", '', '', 0) } as CoreSettings
    }

    private def makeCustomRequestSettings(count) {
        (1..count).collect { new CustomRequestSetting("id-$it", '', false, null) } as CustomRequestSettings
    }
}
